<?php
/*
Plugin: View Member Reported Posts
(c) 2011 Xerotic
Website: http://www.xerotic.net
*/

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

$plugins->add_hook("member_profile_end", "your_reported_posts_profile");
$plugins->add_hook("usercp_start", "your_reported_posts_effect");


function your_reported_posts_info()
{
	return array(
		"name"			=> "هاك مشاهدة تبليغات العضو",
		"description"	=> "تظهر عدد مواضيع العضو المبلغ عنها .",
		"website"		=> "http://www.xerotic.net",
		"author"		=> "Xerotic",
		"authorsite"	=> "http://www.xerotic.net",
		"version"		=> "1.1",
		'codename'		=> "viewreportedposts",
		"GUID"			=> "e2965aa2559a4858a86962e46ce51554"
	);
}

function your_reported_posts_activate()
{
	global $db;
	$info=your_reported_posts_info();
	$setting_group_array=array
	(
		'name'=>$info['codename'],
		'title'=>$info['name'],
		'description'=>'هنا تستطيع تعديل '.$info['name'].' اعدادات.',
		'disporder'=>196,
		'isdefault'=>0
	);
	$db->insert_query('settinggroups',$setting_group_array);
	$group=$db->insert_id();
	$settings=array
	(
		'your_reported_posts_everyone'=>array
		(
			'السماح لجميع المجموعات',
			'في حالة تفعيل هذا الخيار سيري كل المجموعات خانة المواضيع المبلغ عنها',
			'yesno',
			0
		),
		'your_reported_posts_allowed'=>array
		(
			'المجموعات المسموح لها',
			'ضع هنا المجموعات المسموح لها رؤية المواضيع المبلغ عنها في الملف الشخصي',
			'text',
			'4'
		),
		'your_reported_posts_viewown'=>array
		(
			'مخالفات الاعضاء الاخرين',
			'في حالة التفعيل سيري الاعضاء مخالفات بعضهم ويفضل فقط للادارة والمشرفين',
			'yesno',
			0
		),
		'your_reported_posts_viewall'=>array
		(
			'المجموعات المسموح لها',
			'ضع هنا المجموعات المسموح لها رؤية المواضيع المبلغ عنها في الملف الشخصي',
			'text',
			'4'
		)
	);
	$i=1;
	foreach($settings as $name=>$sinfo){
		$insert_array=array
		(
			'name'=>$name,
			'title'=>$db->escape_string($sinfo[0]),
			'description'=>$db->escape_string($sinfo[1]),
			'optionscode'=>$db->escape_string($sinfo[2]),
			'value'=>$db->escape_string($sinfo[3]),
			'gid'=>$group,
			'disporder'=>$i,
			'isdefault'=>0
		);
		$db->insert_query('settings',$insert_array);
		$i++;
	}
	rebuild_settings();

	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "#".preg_quote('{$reputation}')."#i", '{$reputation}<tr><td class="{$bg_color}"><strong>التبليغات</strong></td><td class="{$bg_color}"><a href="usercp.php?action=reports&uid={$uid}">{$numReportsPosts}</a></td></tr>');
}

function your_reported_posts_deactivate()
{
	global $db;
	$info=your_reported_posts_info();
	$result=$db->simple_select('settinggroups','gid','name="'.$info['codename'].'"',array('limit'=>1));
	$group=$db->fetch_array($result);
	if(!empty($group['gid']))
	{
		$db->delete_query('settinggroups','gid="'.$group['gid'].'"');
		$db->delete_query('settings','gid="'.$group['gid'].'"');
		rebuild_settings();
	}

	require_once MYBB_ROOT."/inc/adminfunctions_templates.php";
	find_replace_templatesets("member_profile", "#".preg_quote('<tr><td class="{$bg_color}"><strong>التبليغات:</strong></td><td class="{$bg_color}"><a href="usercp.php?action=reports&uid={$uid}">{$numReportsPosts}</a></td></tr>')."#i", '');
}

function your_reported_posts_effect()
{
	
	if($_GET['action']=="reports") {
		global $db,$mybb,$lang;
		// require_once "./global.php";
		
		$lang->error = "قائمة تبليغات العضو";

		$title = "قائمة التبليغات";
		if(isset($_GET['uid']) && is_numeric($_GET['uid'])) {
			$uid = $_GET['uid'];
		} else {
			$uid=$mybb->user['uid'];
		}
		
		if($mybb->settings['your_reported_posts_everyone']==0){
			$allowed = explode(",",str_replace(" ","",$mybb->settings['your_reported_posts_allowed']));
			if (!in_array($mybb->user['usergroup'], $allowed)) {
				error_no_permission();
			}
		}
		if($mybb->settings['your_reported_posts_viewown']==0){
			$allowed = explode(",",str_replace(" ","",$mybb->settings['your_reported_posts_viewall']));
			if (!in_array($mybb->user['usergroup'], $allowed) && $mybb->user['uid']!=$uid) {
				error_no_permission();
			}
		}
		
		$message = '<table border="0" cellspacing="1" cellpadding="4" class="tborder">';
		$message .= '<tr>
		<td class="tcat" style="width:30%;min-width:160px;"><span class="smalltext"><strong>المشاركة</strong></span></td>
		<td class="tcat" style="width:55%;min-width:160px;"><span class="smalltext"><strong>رسالة التبليغ</strong></span></td>
		<td class="tcat" style="width:4%;;"><span class="smalltext"><strong>الحالة</strong></span></td>
		<td class="tcat" style="width:11%;min-width:160px;"><span class="smalltext"><strong>تاريخ التبليغ</strong></span></td>';
		$message .= '</tr>';

		$query = $db->query("
			SELECT ".TABLE_PREFIX."reportedposts.pid, ".TABLE_PREFIX."reportedposts.reportstatus, ".TABLE_PREFIX."reportedposts.reason, ".TABLE_PREFIX."reportedposts.dateline, ".TABLE_PREFIX."posts.subject
			FROM ".TABLE_PREFIX."reportedposts INNER JOIN ".TABLE_PREFIX."posts ON ".TABLE_PREFIX."reportedposts.pid = ".TABLE_PREFIX."posts.pid
			WHERE ".TABLE_PREFIX."reportedposts.uid='".$uid."'
			ORDER BY dateline DESC
		");

		while($report = $db->fetch_array($query))
		{
			if($report['reportstatus']==1) {
				$status = "Handled";
			} else {
				$status = "In Que";
			}
				$message .= '<tr>
								<td class="trow1" style="width:30%;min-width:160px;"><a href="showthread.php?pid='.$report['pid'].'#pid'.$report['pid'].'">'.$report['subject'].'</a></td>
								<td class="trow2" style="width:55%;min-width:160px;">'.$report['reason'].'</td>
								<td class="trow1" style="width:4%;">'.$status.'</td>
								<td class="trow2" style="width:11%;min-width:160px;">'.my_date($mybb->settings['dateformat'], $report['dateline'], $mybb->user['timezone']).', '.my_date($mybb->settings['timeformat'], $report['dateline'], $mybb->user['timezone']).'</td>
							</tr>';	
		}
		$message .= "</table>";
		error($message,$title);
	}
}

function your_reported_posts_profile()
{
	global $numReportsPosts,$uid,$db;
	$query = $db->query("
			SELECT uid
			FROM ".TABLE_PREFIX."reportedposts
			WHERE uid='".$uid."'
		");
	$numReportsPosts = $db->num_rows($query);
}
	
